/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonInfoCenterRmvRplcSelect;
import com.ibm.hwmca.xfw.service.panel.PBCommonInfoCenterVerifySelect;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterRmvRplcQuery;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterVerifyQuery;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PIDriveInfoCenterExchangeAndVerify
implements Effector {
    private static final String TRACE_MASKT = "XRVXDIFT";
    private static final String TRACE_MASKF = "XRVXDIFF";
    private static final String TRACE_MASKD = "XRVXDIFD";

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> PIDriveInfoCenterExchangeAndVerify.fire");
        try {
            String hmcIPAddress;
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            Iterator it = fruList.iterator();
            ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
            ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
            if (edaf == null) {
                Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterExchangeAndVerify.fire ExternalDataAccessFactory not set in userData");
                throw new EffectorException("ExternalDataAccessFactory not set in userData");
            }
            HashMap<String, Object> hmFruInfo = new HashMap<String, Object>();
            PBCommonInfoCenterRmvRplcSelect pbRmvRplcSelect = new PBCommonInfoCenterRmvRplcSelect();
            PBCommonPostInfoCenterRmvRplcQuery pbRmvRplcQuery = new PBCommonPostInfoCenterRmvRplcQuery();
            PBCommonInfoCenterVerifySelect pbVerifySelect = new PBCommonInfoCenterVerifySelect();
            PBCommonPostInfoCenterVerifyQuery pbVerifyQuery = new PBCommonPostInfoCenterVerifyQuery();
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            Locale clientLocale = Locale.US;
            try {
                hmcIPAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "PIDriveInfoCenterExchangeAndVerify.fire exception caught getting hmc ip addres; using 127.0.0.1");
                hmcIPAddress = "127.0.0.1";
            }
            boolean delayOrSwitchFru = false;
            while (!delayOrSwitchFru && it.hasNext()) {
                ServiceableElement se = (ServiceableElement)it.next();
                hmFruInfo.clear();
                pbRmvRplcSelect.setDataMap(hmFruInfo);
                pbRmvRplcQuery.setDataMap(hmFruInfo);
                pbVerifySelect.setDataMap(hmFruInfo);
                pbVerifyQuery.setDataMap(hmFruInfo);
                ExternalDataAccess eda = edaf.create(null);
                hmFruInfo.put("EXTERNAL_DATA_ACCESS", eda);
                hmFruInfo.put("HMC_HOSTNAME", hmcIPAddress);
                hmFruInfo.put("fruLoc", se.getProperty("LOCATION"));
                hmFruInfo.put("fruDescr", se.getProperty("DESC"));
                hmFruInfo.put("operation", (String)userData.get("FORMATTED_SERVICE_ACTION_NAME"));
                eda.setToken((Serializable)((Object)this.makeInfoCenterURL((String)se.getProperty("EXCHANGE_PROCEDURE"), hmcIPAddress, clientLocale)));
                pbRmvRplcSelect = (PBCommonInfoCenterRmvRplcSelect)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pbRmvRplcSelect.getTemplateName(), pbRmvRplcSelect, userData);
                if (pbRmvRplcSelect.isSecondRadioButtonSelected()) {
                    context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                    delayOrSwitchFru = true;
                    continue;
                }
                if ((pbRmvRplcQuery = (PBCommonPostInfoCenterRmvRplcQuery)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pbRmvRplcQuery.getTemplateName(), pbRmvRplcQuery, userData)).isSecondRadioButtonSelected()) {
                    context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.SWITCH_FRUS);
                    delayOrSwitchFru = true;
                    continue;
                }
                eda.setToken((Serializable)((Object)this.makeInfoCenterURL((String)se.getProperty("VERIFY_PROCEDURE"), hmcIPAddress, clientLocale)));
                pbVerifySelect = (PBCommonInfoCenterVerifySelect)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pbVerifySelect.getTemplateName(), pbVerifySelect, userData);
                if (!(pbVerifyQuery = (PBCommonPostInfoCenterVerifyQuery)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pbVerifyQuery.getTemplateName(), pbVerifyQuery, userData)).isSecondRadioButtonSelected()) continue;
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.SWITCH_FRUS);
                delayOrSwitchFru = true;
            }
            if (!delayOrSwitchFru) {
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.CONTINUE);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterExchangeAndVerify.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }

    private String makeInfoCenterURL(String infoCenterPackageId, String ipaddr, Locale locale) {
        Trace.trace(TRACE_MASKT, "-> PIDriveInfoCenterExchangeAndVerify.makeURL for package: " + infoCenterPackageId + ", locale:" + locale);
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace(TRACE_MASKF, "PIDriveInfoCenterExchangeAndVerify.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        if (infoCenterPackageId == null) {
            Trace.trace(TRACE_MASKF, "PIDriveInfoCenterExchangeAndVerify.makeURL infocenter target package not set!!! - using default infocenter URL");
            infoCenterPackageId = "icmain.htm";
        }
        String retUrl = "http://" + ipaddr + correctUrl + infoCenterPackageId;
        Trace.trace(TRACE_MASKT, "<- PIDriveInfoCenterExchangeAndVerify.makeURL: " + retUrl);
        return retUrl;
    }
}

